/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.console.property;

import filenet.sim.toolkit.console.resources.VWSIMResource;
import filenet.sim.toolkit.utils.VWSIMHelp;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWUserInfo;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.textfield.VWNumericTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public final class VWSIMConsolePreferenceDialog
extends VWModalDialog
implements ActionListener,
KeyListener {
    public static final int STATUS_OK = 1;
    public static final int STATUS_CANCEL = 2;
    private JTabbedPane m_tabbedPanel = new JTabbedPane();
    private VWNumericTextField m_refreshTextField = null;
    private VWNumericTextField m_folderFilterLimitField = null;
    private JButton m_okButton = new JButton(VWSIMResource.s_ok);
    private JButton m_cancelButton = new JButton(VWSIMResource.s_cancel);
    private JButton m_helpButton = new JButton(VWSIMResource.s_help);
    private JComboBox m_unitComboBox = new JComboBox();
    private long m_refreshInterval = 30000L;
    private VWUserInfo m_userInfo = null;
    private VWSession m_vwSession = null;
    private boolean m_bRateModified = false;
    private boolean m_bLimitModified = false;
    private int m_unit = 0;
    private int m_folderFilterLimit = 100;
    private boolean m_bValidInterval = true;
    private boolean m_bValidLimit = true;
    private int m_returnStatus = 0;
    private static final int FOLDER_FILTER_LIMIT_MIN = 50;
    private static final int FOLDER_FILTER_LIMIT_DEFAULT = 100;
    private static final int FOLDER_FILTER_LIMIT_MAX = 5000;

    public VWSIMConsolePreferenceDialog(Frame parent, VWSession session) {
        super(parent);
        this.m_vwSession = session;
        this.init();
    }

    private void init() {
        try {
            this.m_userInfo = this.m_vwSession.fetchCurrentUserInfo();
            Integer iFolderLimit = (Integer)this.m_userInfo.getFieldValue("sim_console_folder_filter_limit");
            if (iFolderLimit != null) {
                int folderLimit = iFolderLimit;
                if (folderLimit >= 50 && folderLimit <= 5000) {
                    this.m_folderFilterLimit = folderLimit;
                } else {
                    iFolderLimit = (Integer)VWIDMBaseFactory.instance().getProperties().getProperty("filterFolderMaxResults");
                    this.m_folderFilterLimit = iFolderLimit != null ? iFolderLimit : 100;
                    this.m_bLimitModified = true;
                }
            } else {
                iFolderLimit = (Integer)VWIDMBaseFactory.instance().getProperties().getProperty("filterFolderMaxResults");
                this.m_folderFilterLimit = iFolderLimit != null ? iFolderLimit : 100;
                this.m_bLimitModified = true;
            }
            Double dRefreshInterval = (Double)this.m_userInfo.getFieldValue("sim_console_refresh_interval");
            if (dRefreshInterval != null && dRefreshInterval.longValue() >= 30000L) {
                this.m_refreshInterval = dRefreshInterval.longValue();
            } else {
                this.m_refreshInterval = 30000L;
                this.m_bRateModified = true;
            }
            if (this.m_bRateModified || this.m_bLimitModified) {
                this.setUserPreferences();
            }
            if (this.m_refreshInterval % 3600000L == 0L && this.m_refreshInterval >= 3600000L) {
                this.m_refreshInterval /= 3600000L;
                this.m_unit = 2;
            } else if (this.m_refreshInterval % 60000L == 0L && this.m_refreshInterval >= 60000L) {
                this.m_refreshInterval /= 60000L;
                this.m_unit = 1;
            } else {
                this.m_refreshInterval /= 1000L;
                this.m_unit = 0;
            }
            this.setupLayout();
        }
        catch (Exception ex) {
            System.out.println(ex.getLocalizedMessage());
            VWDebug.logException(ex);
        }
    }

    protected boolean setUserPreferences() {
        boolean bOk = false;
        try {
            if (this.m_bRateModified || this.m_bLimitModified) {
                if (this.m_bRateModified) {
                    Double dRefreshInterval = new Double(this.m_refreshInterval);
                    this.m_userInfo.setFieldValue("sim_console_refresh_interval", dRefreshInterval);
                }
                if (this.m_bLimitModified) {
                    Integer iFolderFilterLimit = new Integer(this.m_folderFilterLimit);
                    this.m_userInfo.setFieldValue("sim_console_folder_filter_limit", iFolderFilterLimit);
                }
                this.m_userInfo.save();
            }
            bOk = true;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return bOk;
    }

    protected JPanel createRefreshPane() {
        JPanel refreshRatePanel = new JPanel();
        this.m_refreshTextField = new VWNumericTextField(2, 0, false);
        this.m_refreshTextField.setText(Integer.toString((int)this.m_refreshInterval));
        this.m_refreshTextField.addKeyListener(this);
        this.m_refreshTextField.addActionListener(this);
        JTextArea infoTextArea = new JTextArea(VWSIMResource.RefreshIntervalExtraInfo);
        infoTextArea.setLineWrap(true);
        infoTextArea.setWrapStyleWord(true);
        infoTextArea.setOpaque(false);
        infoTextArea.setEditable(false);
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new FlowLayout(3));
        inputPanel.add(new JLabel(VWSIMResource.s_label.toString(VWSIMResource.RefreshInterval)));
        inputPanel.add(this.m_refreshTextField);
        this.m_unitComboBox.addItem(VWSIMResource.s_seconds);
        this.m_unitComboBox.addItem(VWSIMResource.s_minutes);
        this.m_unitComboBox.setSelectedIndex(this.m_unit);
        this.m_unitComboBox.addActionListener(this);
        this.m_unitComboBox.setRenderer(new VWLabelListCellRenderer());
        inputPanel.add(this.m_unitComboBox);
        refreshRatePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbConst = new GridBagConstraints();
        gbConst.gridwidth = 0;
        gbConst.anchor = 23;
        gbConst.gridx = 0;
        gbConst.gridy = 0;
        gbConst.fill = 0;
        gbConst.weightx = 1.0;
        gbConst.weighty = 1.0;
        gbConst.insets = new Insets(6, 6, 6, 6);
        refreshRatePanel.add((Component)inputPanel, gbConst);
        ++gbConst.gridy;
        gbConst.fill = 1;
        refreshRatePanel.add((Component)infoTextArea, gbConst);
        return refreshRatePanel;
    }

    protected JPanel createFolderLimitPane() {
        JPanel folderLimitPanel = new JPanel();
        this.m_folderFilterLimitField = new VWNumericTextField(4, 0, false);
        this.m_folderFilterLimitField.setText(Integer.toString(this.m_folderFilterLimit));
        this.m_folderFilterLimitField.addKeyListener(this);
        this.m_folderFilterLimitField.addActionListener(this);
        JTextArea infoTextArea = new JTextArea(VWSIMResource.FolderFilterLimitInfo);
        infoTextArea.setLineWrap(true);
        infoTextArea.setWrapStyleWord(true);
        infoTextArea.setOpaque(false);
        infoTextArea.setEditable(false);
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new FlowLayout(3));
        inputPanel.add(new JLabel(VWSIMResource.s_label.toString(VWSIMResource.FolderFilterLimit)));
        inputPanel.add(this.m_folderFilterLimitField);
        folderLimitPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbConst = new GridBagConstraints();
        gbConst.gridwidth = 0;
        gbConst.anchor = 23;
        gbConst.gridx = 0;
        gbConst.gridy = 0;
        gbConst.fill = 0;
        gbConst.weightx = 1.0;
        gbConst.weighty = 1.0;
        gbConst.insets = new Insets(6, 6, 6, 6);
        folderLimitPanel.add((Component)inputPanel, gbConst);
        ++gbConst.gridy;
        gbConst.fill = 1;
        folderLimitPanel.add((Component)infoTextArea, gbConst);
        return folderLimitPanel;
    }

    protected JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(this.m_okButton);
        buttonPanel.add(this.m_cancelButton);
        buttonPanel.add(this.m_helpButton);
        return buttonPanel;
    }

    protected void setupLayout() {
        Container contentPane = this.getContentPane();
        this.setResizable(true);
        Dimension dim = VWStringUtils.stringToDimension("450,225");
        if (dim == null) {
            dim = new Dimension(450, 200);
        }
        this.setSize(dim.width, dim.height);
        this.setVisible(false);
        this.setTitle(VWSIMResource.UserPreferences);
        Font aFont = this.getFont();
        Font boldFont = new Font(aFont.getName(), 1, aFont.getSize());
        this.m_tabbedPanel.setFont(boldFont);
        this.m_tabbedPanel.add(VWSIMResource.RefreshInterval, this.createRefreshPane());
        this.m_tabbedPanel.add(VWSIMResource.FolderFilterLimit, this.createFolderLimitPane());
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        mainPanel.setLayout(new BoxLayout(mainPanel, 3));
        mainPanel.add(this.m_tabbedPanel);
        mainPanel.add(this.createButtonPanel());
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)mainPanel, "Center");
        this.m_okButton.addActionListener(this);
        this.m_cancelButton.addActionListener(this);
        this.m_helpButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.m_okButton);
        this.m_okButton.setSelected(true);
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        Object source = e.getSource();
        if (source == this.m_refreshTextField) {
            this.m_bValidInterval = this.parseRefreshInterval();
            this.m_bRateModified = true;
        } else if (source == this.m_folderFilterLimitField) {
            this.m_bValidLimit = this.parseFolderFilterLimit();
            this.m_bLimitModified = true;
        }
        if (this.m_bValidInterval && this.m_bValidLimit) {
            this.m_okButton.setEnabled(true);
        } else {
            this.m_okButton.setEnabled(false);
        }
    }

    public boolean refreshIntervalModified() {
        return this.m_bRateModified;
    }

    public boolean folderFilterLimitModified() {
        return this.m_bLimitModified;
    }

    public int getFolderFilterLimit() {
        return this.m_folderFilterLimit;
    }

    public long getRefreshInterval() {
        return this.m_refreshInterval;
    }

    public int getReturnStatus() {
        return this.m_returnStatus;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_okButton) {
            if (this.setUserPreferences()) {
                this.m_returnStatus = 1;
                this.setVisible(false);
            }
        } else if (source == this.m_cancelButton) {
            this.m_bRateModified = false;
            this.m_bLimitModified = false;
            this.m_returnStatus = 2;
            this.setVisible(false);
        } else if (source == this.m_helpButton) {
            VWSIMHelp.displayPage(VWSIMHelp.Help_Simulation_Config + "vwsimconsolesetrefreshratedialog.htm");
        } else if (source == this.m_refreshTextField) {
            JButton defButton = this.getRootPane().getDefaultButton();
            if (defButton != null) {
                defButton.doClick();
            } else if (this.m_okButton != null) {
                this.m_okButton.doClick();
            }
        } else if (source == this.m_unitComboBox) {
            if (this.parseRefreshInterval()) {
                this.m_okButton.setEnabled(true);
            } else {
                this.m_okButton.setEnabled(false);
            }
        } else if (source == this.m_folderFilterLimitField) {
            JButton defButton = this.getRootPane().getDefaultButton();
            if (defButton != null) {
                defButton.doClick();
            } else if (this.m_okButton != null) {
                this.m_okButton.doClick();
            }
        }
    }

    private boolean parseRefreshInterval() {
        boolean bOk = false;
        String timeString = this.m_refreshTextField.getText();
        try {
            this.m_refreshInterval = Integer.parseInt(timeString);
            switch (this.m_unitComboBox.getSelectedIndex()) {
                case 0: {
                    this.m_refreshInterval *= 1000L;
                    break;
                }
                case 1: {
                    this.m_refreshInterval *= 60000L;
                    break;
                }
                case 2: {
                    this.m_refreshInterval *= 3600000L;
                }
            }
            if (this.m_refreshInterval >= 30000L) {
                bOk = true;
            }
        }
        catch (NumberFormatException ex) {
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return bOk;
    }

    private boolean parseFolderFilterLimit() {
        boolean bOk = false;
        String strLimit = this.m_folderFilterLimitField.getText();
        try {
            this.m_folderFilterLimit = Integer.parseInt(strLimit);
            if (this.m_folderFilterLimit >= 50 && this.m_folderFilterLimit <= 5000) {
                bOk = true;
            }
        }
        catch (NumberFormatException ex) {
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return bOk;
    }
}

